<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kontak Kami | Wisata Asahan</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f5f5f5;
            line-height: 1.6;
        }

        /* NAVBAR */
        .navbar {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 1rem 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .navbar-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            gap: 2rem;
        }

        .navbar a {
            color: white;
            text-decoration: none;
            font-weight: 500;
            transition: opacity 0.3s;
        }

        .navbar a:hover {
            opacity: 0.8;
        }

        /* CONTAINER */
        .container {
            width: 90%;
            max-width: 700px;
            margin: 3rem auto;
            background: white;
            padding: 3rem;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
        }

        h2 {
            text-align: center;
            margin-bottom: 0.5rem;
            color: #667eea;
            font-size: 2rem;
        }

        .subtitle {
            text-align: center;
            color: #666;
            margin-bottom: 2.5rem;
        }

        /* KONTAK INFO */
        .kontak-info {
            margin: 2rem 0;
        }

        .kontak-info p {
            padding: 1rem;
            margin-bottom: 1rem;
            background: #f8f9fa;
            border-radius: 8px;
            border-left: 4px solid #667eea;
            transition: transform 0.2s;
        }

        .kontak-info p:hover {
            transform: translateX(5px);
        }

        .kontak-info strong {
            display: inline-block;
            width: 130px;
            color: #667eea;
            font-weight: 600;
        }

        /* BUTTON */
        .btn-container {
            text-align: center;
            margin-top: 2.5rem;
        }

        .btn {
            display: inline-block;
            padding: 0.9rem 2rem;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            text-decoration: none;
            border-radius: 50px;
            font-weight: 600;
            transition: transform 0.3s, box-shadow 0.3s;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
        }

        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        }

        /* RESPONSIVE */
        @media (max-width: 768px) {
            .navbar-container {
                flex-direction: column;
                gap: 0.5rem;
                text-align: center;
            }

            .container {
                padding: 2rem 1.5rem;
                margin: 2rem auto;
            }

            h2 {
                font-size: 1.6rem;
            }

            .kontak-info strong {
                display: block;
                margin-bottom: 0.3rem;
            }
        }
    </style>
</head>
<body>

<!-- NAVBAR -->
<nav class="navbar">
    <div class="navbar-container">
        <a href="index.php">Beranda</a>
        <a href="kontak.php">Kontak</a>
        <a href="admin/login.php">Login Admin</a>
    </div>
</nav>

<div class="container">
    <h2>Kontak Kami</h2>
    <p class="subtitle">Jika Anda memiliki pertanyaan, kritik, atau saran mengenai wisata di Kabupaten Asahan, silakan hubungi kami.</p>

    <div class="kontak-info">
        <p><strong>Alamat</strong>: Kabupaten Asahan, Sumatera Utara</p>
        <p><strong>Email</strong>: wisataasahan@gmail.com</p>
        <p><strong>Telepon</strong>: 0812-3456-7890</p>
        <p><strong>Jam Layanan</strong>: Senin – Jumat (08.00 – 16.00 WIB)</p>
    </div>

    <div class="btn-container">
        <a href="index.php" class="btn">Kembali ke Beranda</a>
    </div>
</div>

</body>
</html>