<?php
session_start();
include "../config/koneksi.php";
if (!isset($_SESSION['admin'])) {
    header("Location: login.php");
}

$kategori = mysqli_query($koneksi, "SELECT * FROM kategori");

if (isset($_POST['simpan'])) {
    $nama   = $_POST['nama'];
    $kat    = $_POST['kategori'];
    $desk   = $_POST['deskripsi'];
    $alamat = $_POST['alamat'];
    $maps   = $_POST['maps'];

    $gambar = $_FILES['gambar']['name'];
    $tmp    = $_FILES['gambar']['tmp_name'];

    move_uploaded_file($tmp, "../img/".$gambar);

    mysqli_query($koneksi, "
        INSERT INTO wisata (id_kategori, nama_wisata, deskripsi, alamat, gambar, maps)
        VALUES ('$kat','$nama','$desk','$alamat','$gambar','$maps')
    ");

    header("Location: wisata.php");
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Tambah Wisata</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        .maps-preview {
            margin-top: 10px;
            border: 1px solid #ddd;
            padding: 10px;
            border-radius: 4px;
            background: #f9f9f9;
            min-height: 300px;
        }
        .maps-preview iframe {
            width: 100%;
            height: 300px;
            border: none;
            border-radius: 4px;
        }
        .help-text {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }
        .info-box {
            background: #e3f2fd;
            border-left: 4px solid #2196F3;
            padding: 12px;
            margin-bottom: 15px;
            border-radius: 4px;
        }
        .info-box h4 {
            margin-top: 0;
            color: #1976D2;
        }
        .info-box ol {
            margin: 10px 0;
            padding-left: 20px;
        }
        .info-box li {
            margin-bottom: 5px;
        }
    </style>
</head>
<body>

<h2>Tambah Wisata</h2>
<a href="wisata.php">← Kembali</a>

<div class="info-box">
    <h4>📍 Cara Mendapatkan Kode Embed Google Maps:</h4>
    <ol>
        <li>Buka <strong>Google Maps</strong> (maps.google.com)</li>
        <li>Cari lokasi wisata yang ingin ditambahkan</li>
        <li>Klik tombol <strong>"Share"</strong> atau <strong>"Bagikan"</strong></li>
        <li>Pilih tab <strong>"Embed a map"</strong> atau <strong>"Sematkan peta"</strong></li>
        <li>Salin kode HTML yang muncul (kode yang dimulai dengan &lt;iframe...)</li>
        <li>Tempelkan kode tersebut pada kolom "Google Maps Embed Code" di bawah</li>
    </ol>
</div>

<form method="POST" enctype="multipart/form-data">
    <div class="form-group">
        <label>Nama Wisata</label>
        <input type="text" name="nama" required>
    </div>

    <div class="form-group">
        <label>Kategori</label>
        <select name="kategori">
            <?php while($k=mysqli_fetch_assoc($kategori)) { ?>
                <option value="<?= $k['id_kategori'] ?>">
                    <?= $k['nama_kategori'] ?>
                </option>
            <?php } ?>
        </select>
    </div>

    <div class="form-group">
        <label>Deskripsi</label>
        <textarea name="deskripsi" rows="4"></textarea>
    </div>

    <div class="form-group">
        <label>Alamat</label>
        <input type="text" name="alamat">
    </div>

    <div class="form-group">
        <label>Gambar</label>
        <input type="file" name="gambar" required>
    </div>

    <div class="form-group">
        <label>Google Maps Embed Code</label>
        <textarea name="maps" id="mapsCode" rows="5" placeholder='Contoh: <iframe src="https://www.google.com/maps/embed?pb=..." width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"></iframe>'></textarea>
        <div class="help-text">
            Tempelkan kode embed dari Google Maps di sini. Kode dimulai dengan &lt;iframe...
        </div>
    </div>

    <div class="form-group">
        <label>Preview Peta:</label>
        <div class="maps-preview" id="mapsPreview">
            <p style="text-align: center; color: #999; padding: 50px 0;">
                Preview peta akan muncul di sini setelah Anda menempelkan kode embed
            </p>
        </div>
    </div>

    <br>
    <button type="submit" name="simpan">Simpan</button>
</form>

<script>
// Preview maps saat mengetik
document.getElementById('mapsCode').addEventListener('input', function() {
    const mapsCode = this.value.trim();
    const previewContainer = document.getElementById('mapsPreview');
    
    if (mapsCode) {
        previewContainer.innerHTML = mapsCode;
    } else {
        previewContainer.innerHTML = '<p style="text-align: center; color: #999; padding: 50px 0;">Preview peta akan muncul di sini setelah Anda menempelkan kode embed</p>';
    }
});
</script>

</body>
</html>